--[[---------------------------------------------------------------------------
	Chocolatier Two Standard UI
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-- COLORS
BlackColor = Color(0,0,0,255)
WhiteColor = Color(255,255,255,255)
GrayColor = Color(128,128,128,255)
YellowColor = Color(255,235,110,255)
RedColor = Color(144,27,27,255)
GreenColor = Color(57,97,51)
BrownColor = Color(90,61,17,255)
DefaultColor = BlackColor		-- default for text and button labels

MarketColor = Color(160,210,121,255)
ShopColor = Color(191,127,171,255)
CharacterColor = Color(157,87,115,255)
DialogColor = Color(217,165,134,255)	-- Color(254,215,170,255)

PopupColor = Color(220,215,208,255)

local HaggleGreenColor = {74,160,8}
local HaggleRedColor = {193,12,12}
BetterPriceColor = string.format("<font color='%02x%02x%02x'>", HaggleGreenColor[1], HaggleGreenColor[2], HaggleGreenColor[3])
WorsePriceColor = string.format("<font color='%02x%02x%02x'>", HaggleRedColor[1], HaggleRedColor[2], HaggleRedColor[3])

-- FONTS
simpleFontName = "fonts/caliban.mvec"
courierFontName = "fonts/caliban.mvec"		-- TODO

--standardFontName = "fonts/bolton.mvec"
--standardFontName = "fonts/parisian.mvec"
--standardFontName = "fonts/fontin.mvec"
standardFontName = "fonts/fertigo.mvec"

kTwelve = 12
kFourteen = 14
kFifteen = 15
kSixteen = 16
kSeventeen = 17
kEighteen = 18
kTwenty = 20
kTwentyTwo = 22
kTwentyThree = 23
kTwentyFour = 24
kTwentyEight = 28
kThirty = 30
kThirtyTwo = 32
kForty = 40
kEighty = 80
kOneHundred = 100
kOneTwenty = 120

standardFont = { standardFontName, kEighteen, DefaultColor }
standardYellowFont = { standardFontName, kEighteen, YellowColor }
standardWhiteFont = { standardFontName, kEighteen, WhiteColor }
standardGrayFont = { standardFontName, kEighteen, GrayColor }
dialogFont = { standardFontName, kEighteen, DefaultColor }
smallDialogFont = { standardFontName, kFourteen, DefaultColor }
travelTagFont = { standardFontName, kSixteen, DefaultColor }
popupFont = { standardFontName, kEighteen, DefaultColor }
helpFont = { standardFontName, kTwenty, DefaultColor }

invFont = { standardFontName, kEighteen, DefaultColor }
invSmallFont = { standardFontName, kSixteen, DefaultColor }
invTinyFont = { standardFontName, kSixteen, DefaultColor }

recipeTitleFont = { standardFontName, kTwentyEight, DefaultColor }
recipeFont = { standardFontName, kEighteen, DefaultColor }

charNameFontLight = { standardFontName, kSixteen, WhiteColor }
charNameFontDark = { standardFontName, kSixteen, BlackColor }

helpTitleFont = { standardFontName, kThirty, BlackColor }

productionFont = { standardFontName, kOneHundred, RedColor }

-- BUTTONS
standardStyle =
{
	type = kPush,
	font = standardFont,
	flags = kVAlignCenter + kHAlignCenter,

	-- Default rollover hotspot size
	hotSize = 20,

	-- Default button	
	graphics = { "control/default_up", "control/default_down", "control/default_over" },
	sound = "sfx/ui_click.ogg",

	-- Default frame
	corner="control/frame_corner",
	left="control/frame_left",
	top="control/frame_top",
	ornament="control/frame_ornament",
}

SetDefaultStyle(standardStyle)

-- ROLLOVER FRAME

rolloverStyle =
{
	x=0,y=0,fit=true,empty=true,
	corner="control/rollover_corner",
	left="control/rollover_left",
	top="control/rollover_top",
	ornament="",
}

-- STANDARD BUTTONS

LeftButtonGraphics = { "control/btn_prev_up", "control/btn_prev_down", "control/btn_prev_over" }
CloseButtonGraphics = { "control/btn_close_up", "control/btn_close_down", "control/btn_close_over" }

MediumButtonGraphics = { "control/default_med_up", "control/default_med_down", "control/default_med_over" }
SmallButtonGraphics = { "control/default_small_up", "control/default_small_down", "control/default_small_over" }

CheckButtonGraphics = { "control/radio_uncheck", "control/radio_check", "control/radio_uncheck_over", "control/radio_check_over" }

-- SLIDERS
sliderFont = { standardFontName, kSixteen, BlackColor }
sliderStyle = 
{
	parent=standardStyle,
	railtop = "control/sliderrailtop",	
	railmid = "control/sliderrailmid",
	railbot = "control/sliderrailbot",
	sliderimage = "control/sliderknob",
	yoffset = -1,
	sliderrollimage = "control/sliderknobover",
}

-- STRING CONSTANTS
kNumbersOnly = "`~!@#$%^&*()_-+={[}]|\\:;\"'<,>.?/ ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"
kIgnoreBadNameChars = "!@#$%^&*()><\\\"\'[]{}|?/+=~`.,;:-"
kIgnoreBadSignChars = "<>\\\""	-- "~@#^+={}|\\<>"

-- PORT INCIDENTALS
portPlanes = { "aircraft_03","aircraft_04","aircraft_05" }
portAirships = { "aircraft_01","aircraft_02" }
portBoats = { "boat_01","boat_02","boat_04" }
portCars = { "car_01.xml","car_02","car_03.xml","car_04.xml","car_05.xml","car_08", }
portTrains = { "train_01","train_02","train_03" }
